@echo off
setlocal EnableDelayedExpansion

echo =====================================
echo FFMPEG -> WAV (Stereo / 5.1 Split)
echo =====================================

set OUTDIR=wav51_out
if not exist "%OUTDIR%" mkdir "%OUTDIR%"

for %%F in (*.aac *.ac3 *.wav *.aif *.aiff) do (

    echo.
    echo Datei: %%F

    rem -------------------------------
    rem Kanalanzahl ermitteln
    rem -------------------------------
    set CH=
    for /f "delims=" %%C in ('
        ffprobe -v error -select_streams a:0 ^
        -show_entries stream^=channels ^
        -of default^=noprint_wrappers^=1:nokey^=1 "%%F"
    ') do set CH=%%C

    echo Kanaele: !CH!

    rem ===============================
    rem STEREO
    rem ===============================
    if "!CH!"=="2" (
        echo -> Stereo

        ffmpeg -y -i "%%F" ^
        -c:a pcm_s16le ^
        "%OUTDIR%\%%~nF.wav"
    )

    rem ===============================
    rem 5.1
    rem ===============================
    if "!CH!"=="6" (
        echo -> 5.1

        rem Front L/R
        ffmpeg -y -i "%%F" ^
        -filter_complex "pan=stereo|c0=c0|c1=c1" ^
        -c:a pcm_s16le ^
        "%OUTDIR%\%%~nF_1front.wav"

        rem Center + LFE
        ffmpeg -y -i "%%F" ^
        -filter_complex "pan=stereo|c0=c2|c1=c3" ^
        -c:a pcm_s16le ^
        "%OUTDIR%\%%~nF_3center_lfe.wav"

        rem Rear L/R
        ffmpeg -y -i "%%F" ^
        -filter_complex "pan=stereo|c0=c4|c1=c5" ^
        -c:a pcm_s16le ^
        "%OUTDIR%\%%~nF_2rear.wav"
    )
)

echo.
echo Fertig.
pause
